
#pragma once
/****************************************************************************/
/*		SPEAKERBOX 104 DEFINES                                              */
/****************************************************************************/

// available audio outputs
#define SBX104_HEADSET_SPEAKER				0x00
#define SBX104_EXTERNAL_SPEAKER				0x02
#define SBX104_RECORDING_OUTPUT				0x03

// audio outputs levels
#define SBX104_AUDIO_OUTPUT_LEVEL_0			0x00
#define SBX104_AUDIO_OUTPUT_LEVEL_1			0x01
#define SBX104_AUDIO_OUTPUT_LEVEL_2			0x02
#define SBX104_AUDIO_OUTPUT_LEVEL_3			0x03
#define SBX104_AUDIO_OUTPUT_LEVEL_4			0x04
#define SBX104_AUDIO_OUTPUT_LEVEL_5			0x05
#define SBX104_AUDIO_OUTPUT_LEVEL_6			0x06
#define SBX104_AUDIO_OUTPUT_LEVEL_7			0x07
#define SBX104_AUDIO_OUTPUT_LEVEL_8			0x08
#define SBX104_AUDIO_OUTPUT_LEVEL_9			0x09
#define SBX104_AUDIO_OUTPUT_LEVEL_10		0x0A

#define SBX104_AUDIO_OUTPUT_LEVEL_MIN		SBX104_AUDIO_OUTPUT_LEVEL_0
#define SBX104_AUDIO_OUTPUT_LEVEL_MAX		SBX104_AUDIO_OUTPUT_LEVEL_10

// LEDs
#define SBX104_LED_1						0x00	/* LED can not be used by API ( used for 12V detection ) */
#define SBX104_LED_2						0x01	/* LED can not be used by API ( used for microphone state indication ) */
#define SBX104_LED_3						0x02
#define SBX104_LED_4						0x03

#define SBX104_LED_OFF						0x00
#define SBX104_LED_ON						0x01

// microphone
#define SBX104_MIC_ACTIVE					0x00
#define SBX104_MIC_MUTE						0x01

// microphone level
#define SBX104_MIC_LEVEL_0					0x00
#define SBX104_MIC_LEVEL_1					0x01
#define SBX104_MIC_LEVEL_2					0x02
#define SBX104_MIC_LEVEL_3					0x03
#define SBX104_MIC_LEVEL_4					0x04
#define SBX104_MIC_LEVEL_5					0x05
#define SBX104_MIC_LEVEL_6					0x06
#define SBX104_MIC_LEVEL_7					0x07
#define SBX104_MIC_LEVEL_8					0x08
#define SBX104_MIC_LEVEL_9					0x09
#define SBX104_MIC_LEVEL_10					0x0A
#define SBX104_MIC_LEVEL_11					0x0B
#define SBX104_MIC_LEVEL_12					0x0C
#define SBX104_MIC_LEVEL_13					0x0D
#define SBX104_MIC_LEVEL_14					0x0E

#define SBX104_MIC_LEVEL_MIN				SBX104_MIC_LEVEL_0
#define SBX104_MIC_LEVEL_MAX				SBX104_MIC_LEVEL_14

// microphone pre-amplifer level
#define SBX104_MIC_PRE_AMP_LEVEL_0			0x00
#define SBX104_MIC_PRE_AMP_LEVEL_1			0x01
#define SBX104_MIC_PRE_AMP_LEVEL_2			0x02
#define SBX104_MIC_PRE_AMP_LEVEL_3			0x03
#define SBX104_MIC_PRE_AMP_LEVEL_4			0x04
#define SBX104_MIC_PRE_AMP_LEVEL_5			0x05
#define SBX104_MIC_PRE_AMP_LEVEL_6			0x06
#define SBX104_MIC_PRE_AMP_LEVEL_7			0x07
#define SBX104_MIC_PRE_AMP_LEVEL_8			0x08
#define SBX104_MIC_PRE_AMP_LEVEL_9			0x09
#define SBX104_MIC_PRE_AMP_LEVEL_10			0x0A

#define SBX104_MIC_PRE_AMP_LEVEL_MIN		SBX104_MIC_PRE_AMP_LEVEL_0
#define SBX104_MIC_PRE_AMP_LEVEL_MAX		SBX104_MIC_PRE_AMP_LEVEL_10


// compression settings
#define SBX104_MIC_COMPRESSION_OFF			0x10
#define SBX104_MIC_COMPRESSION_ON			0x11
#define SBX104_MIC_COMPRESSION_ILLEGAL		0xFF


// noise threshold
#define SBX104_MIC_THRESHOLD_VERY_LOW		0x10
#define SBX104_MIC_THRESHOLD_LOW			0x11
#define SBX104_MIC_THRESHOLD_MID			0x12
#define SBX104_MIC_THRESHOLD_HIGH			0x13
#define SBX104_MIC_THRESHOLD_ILLEGAL		0xFF

#define SBX104_MIC_THRESHOLD_MIN			SBX104_MIC_THRESHOLD_VERY_LOW
#define SBX104_MIC_THRESHOLD_MAX			SBX104_MIC_THRESHOLD_HIGH
