
/****************************************************************************/
/* STANDARD HANDSET DEFINES													*/
/****************************************************************************/

// microphone

#define HXX_MIC_ATT_0					0x00
#define HXX_MIC_ATT_1					0x01
#define HXX_MIC_ATT_2					0x02
#define HXX_MIC_ATT_3					0x03
#define HXX_MIC_ATT_4					0x04
#define HXX_MIC_ATT_5					0x05
#define HXX_MIC_ATT_6					0x06
#define HXX_MIC_ATT_7					0x07
#define HXX_MIC_ATT_8					0x08
#define HXX_MIC_ATT_9					0x09
#define HXX_MIC_ATT_10					0x0A
#define HXX_MIC_ATT_11					0x0B
#define HXX_MIC_ATT_12					0x0C
#define HXX_MIC_ATT_13					0x0D
#define HXX_MIC_ATT_14					0x0E
#define	HXX_MIC_ATT_INIT_EEP			0xF0
#define HXX_MIC_MUTE					0xF3
#define HXX_MIC_RESTORE					0xF4


// paramters limited to usefull range
#define HXX_MIC_ATT_MIN					HXX_MIC_ATT_0
#define HXX_MIC_ATT_MAX					HXX_MIC_ATT_14

// compression settings
#define HXX_MIC_COMPRESSION_OFF			0x10
#define HXX_MIC_COMPRESSION_ON			0x11

#define HXX_MIC_COMPRESSION_MIN			HXX_MIC_COMPRESSION_OFF
#define HXX_MIC_COMPRESSION_MAX			HXX_MIC_COMPRESSION_ON

// noise threshold
#define HXX_MIC_THRESHOLD_HIGH			0x10
#define HXX_MIC_THRESHOLD_MID			0x11
#define HXX_MIC_THRESHOLD_LOW			0x12
#define HXX_MIC_THRESHOLD_LOWER			0x13
#define HXX_MIC_THRESHOLD_VERY_LOW		0x14
#define HXX_MIC_THRESHOLD_ILLEGAL		0xFF

#define HXX_MIC_THRESHOLD_MIN			HXX_MIC_THRESHOLD_HIGH
#define HXX_MIC_THRESHOLD_MAX			HXX_MIC_THRESHOLD_VERY_LOW

// Microphone optimal distance
#define HXX_MIC_DISTANCE_M5				0x07
#define HXX_MIC_DISTANCE_M4				0x08
#define HXX_MIC_DISTANCE_M3				0x09
#define HXX_MIC_DISTANCE_M2				0x0A
#define HXX_MIC_DISTANCE_M1				0x0B
#define HXX_MIC_DISTANCE_0				0x0C
#define HXX_MIC_DISTANCE_P1				0x0D
#define HXX_MIC_DISTANCE_P2				0x0E
#define HXX_MIC_DISTANCE_P3				0x0F
#define HXX_MIC_DISTANCE_P4				0x10
#define HXX_MIC_DISTANCE_P5				0x11

#define HXX_MIC_DISTANCE_MIN			HXX_MIC_DISTANCE_M5
#define HXX_MIC_DISTANCE_MAX			HXX_MIC_DISTANCE_P5

// Microphone mode
#define HXX_MICAMP_MODE_LOG				0x00
#define HXX_MICAMP_MODE_LIN				0x04

// speaker

#define HXX_SPEAKER_LEVEL_P2			0x00
#define HXX_SPEAKER_LEVEL_P1			0x01
#define HXX_SPEAKER_LEVEL_0				0x02
#define HXX_SPEAKER_LEVEL_M1			0x03
#define HXX_SPEAKER_LEVEL_M2			0x04
#define HXX_SPEAKER_LEVEL_M3			0x05
#define HXX_SPEAKER_LEVEL_M4			0x06
#define HXX_SPEAKER_LEVEL_M5			0x07
#define HXX_SPEAKER_LEVEL_M6			0x08
#define HXX_SPEAKER_LEVEL_M7			0x09
#define HXX_SPEAKER_LEVEL_M8			0x0A
#define HXX_SPEAKER_LEVEL_ILLEGAL		0xFF
#define HXX_SPEAKER_MUTE				0xF3
#define HXX_SPEAKER_RESTORE				0xF4

#define HXX_SPEAKER_LEVEL_MIN	HXX_SPEAKER_LEVEL_P2
#define HXX_SPEAKER_LEVEL_MAX	HXX_SPEAKER_LEVEL_M8

/****************************************************************************/
/* HAA HANDSET DEFINES														*/
/****************************************************************************/
// Microphone optimal distance
#define HAA_MIC_DISTANCE_M5				0x07
#define HAA_MIC_DISTANCE_M4				0x08
#define HAA_MIC_DISTANCE_M3				0x09
#define HAA_MIC_DISTANCE_M2				0x0A
#define HAA_MIC_DISTANCE_M1				0x0B
#define HAA_MIC_DISTANCE_0				0x0C
#define HAA_MIC_DISTANCE_P1				0x0D
#define HAA_MIC_DISTANCE_P2				0x0E
#define HAA_MIC_DISTANCE_P3				0x0F
#define HAA_MIC_DISTANCE_P4				0x10
#define HAA_MIC_DISTANCE_P5				0x11

#define HAA_MIC_DISTANCE_MIN			HAA_MIC_DISTANCE_M5
#define HAA_MIC_DISTANCE_MAX			HAA_MIC_DISTANCE_P5

// Handset sidetone level
#define HAA_SIDETONE_LEVEL_M1					0x00
#define HAA_SIDETONE_LEVEL_M2					0x01
#define HAA_SIDETONE_LEVEL_M3					0x02
#define HAA_SIDETONE_LEVEL_M4					0x03
#define HAA_SIDETONE_LEVEL_M5					0x04
#define HAA_SIDETONE_LEVEL_M6					0x05
#define HAA_SIDETONE_LEVEL_M7					0x06
#define HAA_SIDETONE_LEVEL_M8					0x07
#define HAA_SIDETONE_LEVEL_M9					0x08
#define HAA_SIDETONE_OFF						0xFE
#define HAA_SIDETONE_ILLEGAL					0xFF
// limits to check
#define HAA_SIDETONE_MIN						HAA_SIDETONE_LEVEL_M1
#define HAA_SIDETONE_MAX						HAA_SIDETONE_LEVEL_M9

/****************************************************************************/
/*		Handset with audio monitoring defines								*/
/****************************************************************************/

// paramters for near-end microphone signal attenuation (HXX_EXTCMD_AM_HS_MIC_MIX)
#define HXX_AM_HS_MIC_MIX_ATT_0			0x00
#define HXX_AM_HS_MIC_MIX_ATT_1			0x01
#define HXX_AM_HS_MIC_MIX_ATT_2			0x02
#define HXX_AM_HS_MIC_MIX_ATT_3			0x03
#define HXX_AM_HS_MIC_MIX_ATT_4			0x04
#define HXX_AM_HS_MIC_MIX_ATT_5			0x05
#define HXX_AM_HS_MIC_MIX_ATT_6			0x06
#define HXX_AM_HS_MIC_MIX_ATT_7			0x07
#define HXX_AM_HS_MIC_MIX_ATT_8			0x08
#define HXX_AM_HS_MIC_MIX_ATT_9			0x09
#define HXX_AM_HS_MIC_MIX_ATT_10		0x0A
#define HXX_AM_HS_MIC_MIX_ATT_11		0x0B
#define HXX_AM_HS_MIC_MIX_ATT_12		0x0C
#define HXX_AM_HS_MIC_MIX_ATT_13		0x0D
#define HXX_AM_HS_MIC_MIX_ATT_14		0x0E
#define	HXX_AM_HS_MIC_MIX_INIT_EEP		0xF0
#define HXX_AM_HS_MIC_MIX_GAIN_INC		0xF1
#define HXX_AM_HS_MIC_MIX_GAIN_DEC		0xF2
#define HXX_AM_HS_MIC_MIX_MUTE			0xF3
#define HXX_AM_HS_MIC_MIX_RESTORE		0xF4

#define HXX_AM_HS_MIC_MIX_ATT_MIN		HXX_AM_HS_MIC_MIX_ATT_0
#define HXX_AM_HS_MIC_MIX_ATT_MAX		HXX_AM_HS_MIC_MIX_ATT_14

// parameters for audio monitoring output signal amplification (HXX_EXTCMD_AM_SPK_AMP)
#define HXX_AM_SPK_LEVEL_P4			0x00
#define HXX_AM_SPK_LEVEL_P3			0x01
#define HXX_AM_SPK_LEVEL_P2			0x02
#define HXX_AM_SPK_LEVEL_P1			0x03
#define HXX_AM_SPK_LEVEL_0			0x04
#define HXX_AM_SPK_LEVEL_M1			0x05
#define HXX_AM_SPK_LEVEL_M2			0x06
#define HXX_AM_SPK_LEVEL_M3			0x07
#define HXX_AM_SPK_LEVEL_M4			0x08
#define HXX_AM_SPK_LEVEL_M5			0x09
#define HXX_AM_SPK_LEVEL_M6			0x0A
#define	HXX_AM_SPK_LEVEL_INIT_EEP	0xF0
#define HXX_AM_SPK_LEVEL_INC		0xF1
#define HXX_AM_SPK_LEVEL_DEC		0xF2
#define HXX_AM_SPK_MUTE				0xF3
#define HXX_AM_SPK_RESTORE			0xF4

#define HXX_AM_SPK_LEVEL_MIN		HXX_AM_SPK_LEVEL_P4
#define HXX_AM_SPK_LEVEL_MAX		HXX_AM_SPK_LEVEL_M6


