
/****************************************************************************/
/* STANDARD Headset Add-on DEFINES												*/
/****************************************************************************/
#pragma once

// microphone
#define HDS_MIC_ATT_0					0x00
#define HDS_MIC_ATT_1					0x01
#define HDS_MIC_ATT_2					0x02
#define HDS_MIC_ATT_3					0x03
#define HDS_MIC_ATT_4					0x04
#define HDS_MIC_ATT_5					0x05
#define HDS_MIC_ATT_6					0x06
#define HDS_MIC_ATT_7					0x07
#define HDS_MIC_ATT_8					0x08
#define HDS_MIC_ATT_9					0x09
#define HDS_MIC_ATT_10					0x0A
#define HDS_MIC_ATT_11					0x0B
#define HDS_MIC_ATT_12					0x0C
#define HDS_MIC_ATT_13					0x0D
#define HDS_MIC_ATT_14					0x0E
#define	HDS_MIC_ATT_INIT_EEP			0xF0
#define HDS_MIC_MUTE					0xF3
#define HDS_MIC_RESTORE					0xF4


// paramters limited to usefull range
#define HDS_MIC_ATT_MIN					HDS_MIC_ATT_0
#define HDS_MIC_ATT_MAX					HDS_MIC_ATT_14

// compression settings
#define HDS_MIC_COMPRESSION_OFF			0x10
#define HDS_MIC_COMPRESSION_ON			0x11

#define HDS_MIC_COMPRESSION_MIN			HDS_MIC_COMPRESSION_OFF
#define HDS_MIC_COMPRESSION_MAX			HDS_MIC_COMPRESSION_ON

// noise threshold
#define HDS_MIC_THRESHOLD_HIGH			0x10
#define HDS_MIC_THRESHOLD_MID			0x11
#define HDS_MIC_THRESHOLD_LOW			0x12
#define HDS_MIC_THRESHOLD_LOWER			0x13
#define HDS_MIC_THRESHOLD_VERY_LOW		0x14
#define HDS_MIC_THRESHOLD_ILLEGAL		0xFF

#define HDS_MIC_THRESHOLD_MIN			HDS_MIC_THRESHOLD_HIGH
#define HDS_MIC_THRESHOLD_MAX			HDS_MIC_THRESHOLD_VERY_LOW

// Microphone optimal distance
#define HDS_MIC_DISTANCE_M5				0x07
#define HDS_MIC_DISTANCE_M4				0x08
#define HDS_MIC_DISTANCE_M3				0x09
#define HDS_MIC_DISTANCE_M2				0x0A
#define HDS_MIC_DISTANCE_M1				0x0B
#define HDS_MIC_DISTANCE_0				0x0C
#define HDS_MIC_DISTANCE_P1				0x0D
#define HDS_MIC_DISTANCE_P2				0x0E
#define HDS_MIC_DISTANCE_P3				0x0F
#define HDS_MIC_DISTANCE_P4				0x10
#define HDS_MIC_DISTANCE_P5				0x11

#define HDS_MIC_DISTANCE_MIN			HDS_MIC_DISTANCE_M5
#define HDS_MIC_DISTANCE_MAX			HDS_MIC_DISTANCE_P5

// Microphone mode
#define HDS_MICAMP_MODE_LOG				0x00
#define HDS_MICAMP_MODE_LIN				0x04

// Headset speaker
#define HDS_SPEAKER_LEVEL_P2			0x00
#define HDS_SPEAKER_LEVEL_P1			0x01
#define HDS_SPEAKER_LEVEL_0				0x02
#define HDS_SPEAKER_LEVEL_M1			0x03
#define HDS_SPEAKER_LEVEL_M2			0x04
#define HDS_SPEAKER_LEVEL_M3			0x05
#define HDS_SPEAKER_LEVEL_M4			0x06
#define HDS_SPEAKER_LEVEL_M5			0x07
#define HDS_SPEAKER_LEVEL_M6			0x08
#define HDS_SPEAKER_LEVEL_M7			0x09
#define HDS_SPEAKER_LEVEL_M8			0x0A
#define HDS_SPEAKER_LEVEL_ILLEGAL		0xFF
#define HDS_SPEAKER_MUTE				0xF3
#define HDS_SPEAKER_RESTORE				0xF4

#define HDS_SPEAKER_LEVEL_MIN	HDS_SPEAKER_LEVEL_P2
#define HDS_SPEAKER_LEVEL_MAX	HDS_SPEAKER_LEVEL_M8


// Microphone optimal distance
#define HDS_MIC_DISTANCE_M5				0x07
#define HDS_MIC_DISTANCE_M4				0x08
#define HDS_MIC_DISTANCE_M3				0x09
#define HDS_MIC_DISTANCE_M2				0x0A
#define HDS_MIC_DISTANCE_M1				0x0B
#define HDS_MIC_DISTANCE_0				0x0C
#define HDS_MIC_DISTANCE_P1				0x0D
#define HDS_MIC_DISTANCE_P2				0x0E
#define HDS_MIC_DISTANCE_P3				0x0F
#define HDS_MIC_DISTANCE_P4				0x10
#define HDS_MIC_DISTANCE_P5				0x11

#define HDS_MIC_DISTANCE_MIN			HDS_MIC_DISTANCE_M5
#define HDS_MIC_DISTANCE_MAX			HDS_MIC_DISTANCE_P5

// Headset sidetone level
#define HDS_SIDETONE_LEVEL_M1					0x00
#define HDS_SIDETONE_LEVEL_M2					0x01
#define HDS_SIDETONE_LEVEL_M3					0x02
#define HDS_SIDETONE_LEVEL_M4					0x03
#define HDS_SIDETONE_LEVEL_M5					0x04
#define HDS_SIDETONE_LEVEL_M6					0x05
#define HDS_SIDETONE_LEVEL_M7					0x06
#define HDS_SIDETONE_LEVEL_M8					0x07
#define HDS_SIDETONE_LEVEL_M9					0x08
#define HDS_SIDETONE_OFF						0xFE
#define HDS_SIDETONE_ILLEGAL					0xFF
// limits to check
#define HDS_SIDETONE_MIN						HDS_SIDETONE_LEVEL_M1
#define HDS_SIDETONE_MAX						HDS_SIDETONE_LEVEL_M9

// Headset line-out level
#define HDS_LINEOUT_LEVEL_P6					0x00
#define HDS_LINEOUT_LEVEL_P5					0x01
#define HDS_LINEOUT_LEVEL_P4					0x02
#define HDS_LINEOUT_LEVEL_P3					0x03
#define HDS_LINEOUT_LEVEL_P2					0x04
#define HDS_LINEOUT_LEVEL_P1					0x05
#define HDS_LINEOUT_LEVEL_0						0x06
#define HDS_LINEOUT_LEVEL_M1					0x07
#define HDS_LINEOUT_LEVEL_M2					0x08
#define HDS_LINEOUT_LEVEL_M3					0x09
#define HDS_LINEOUT_LEVEL_M4					0x0A
#define HDS_LINEOUT_LEVEL_M5					0x0B
#define HDS_LINEOUT_LEVEL_M6					0x0C
#define HDS_LINEOUT_LEVEL_M7					0x0D
#define HDS_LINEOUT_LEVEL_M8					0x0E
#define HDS_LINEOUT_LEVEL_M9					0x0F
#define HDS_LINEOUT_LEVEL_M10					0x10
#define HDS_LINEOUT_LEVEL_M11					0x11
#define HDS_LINEOUT_LEVEL_M12					0x12
#define HDS_LINEOUT_LEVEL_M13					0x13
#define HDS_LINEOUT_LEVEL_MUTE					0x14
// limits to check
#define HDS_LINEOUT_LEVEL_MIN					HDS_LINEOUT_LEVEL_P6
#define HDS_LINEOUT_LEVEL_MAX					HDS_LINEOUT_LEVEL_MUTE

