
/****************************************************************************/
/*		BF22 DEFINES														*/
/****************************************************************************/

// PCM scenario
#define BF22_PCM_SCENARIO_AB			0x3C
#define BF22_PCM_SCENARIO_LR			0x3D
#define BF22_PCM_SCENARIO_VOID			0x3F
#define BF22_PCM_SCENARIO_MASK			0x03

// microphone amplifier mode
#define BF22_MICAMP_MODE_LOG			0x33
#define BF22_MICAMP_MODE_LIN			0x37
#define BF22_MICAMP_MODE_VOID			0x3F
#define BF22_MICAMP_MODE_MASK			0x0C

// central (low frequency) speaker 
#define BF22_LF_SPK_OFF					0x3C
#define BF22_LF_SPK_ON					0x3D
#define BF22_LF_SPK_VOID				0x3F
#define BF22_LF_SPK_MASK				0x03

// showing microphone signal on VU meter
#define BF22_VU_AB_MIC_OFF				0x33
#define BF22_VU_AB_MIC_ON				0x37
#define BF22_VU_AB_MIC_VOID				0x3F
#define BF22_VU_AB_MIC_MASK				0x0C

// analog line out to speakers
#define BF22_LINE_OUT_OFF_SPK			0x10
#define BF22_LINE_OUT_ON_L_SPK			0x11
#define BF22_LINE_OUT_ON_R_SPK			0x12
#define BF22_LINE_OUT_ON_LR_SPK			0x13
#define BF22_LINE_OUT_VOID				0x14
#define BF22_LINE_OUT_MASK				0x03

// microphone to analog line in
#define BF22_MIC_OFF_LINE_IN			0x04
#define BF22_MIC_ON_LINE_IN				0x0C
#define BF22_MIC_LINE_IN_VOID			0x14
#define BF22_MIC_LINE_IN_MASK			0x08

// echo canceller
#define BF22_EC_OFF						0x00
#define BF22_EC_ON_L					0x01
#define BF22_EC_ON_R					0x02
#define BF22_EC_ON_LR					0x03
#define BF22_EC_VOID					0x07
#define BF22_EC_MASK					0x03

// microphone level (attenuation)
#define BF22_MIC_LEVEL_P3				0x10
#define BF22_MIC_LEVEL_P2				0x11
#define BF22_MIC_LEVEL_P1				0x12
#define BF22_MIC_LEVEL_0				0x13
#define BF22_MIC_LEVEL_M1				0x14
#define BF22_MIC_LEVEL_M2				0x15
#define BF22_MIC_LEVEL_M3				0x16
#define BF22_MIC_LEVEL_M4				0x17
#define BF22_MIC_LEVEL_M5				0x18
#define BF22_MIC_LEVEL_M6				0x19
#define BF22_MIC_LEVEL_M7				0x1A	
#define BF22_MIC_LEVEL_M8				0x1B
#define BF22_MIC_LEVEL_M9				0x1C
#define BF22_MIC_LEVEL_M10				0x1D
#define BF22_MIC_LEVEL_M11				0x1E

#define BF22_MIC_LEVEL_MIN				BF22_MIC_LEVEL_P3
#define BF22_MIC_LEVEL_MAX				BF22_MIC_LEVEL_M11

//microphone optimal distance
#define BF22_MIC_DISTANCE_M2			0x0A
#define BF22_MIC_DISTANCE_M1			0x0B
#define BF22_MIC_DISTANCE_0				0x0C
#define BF22_MIC_DISTANCE_P1			0x0D
#define BF22_MIC_DISTANCE_P2			0x0E
#define BF22_MIC_DISTANCE_P3			0x0F
#define BF22_MIC_DISTANCE_P4			0x10
#define BF22_MIC_DISTANCE_P5			0x11
#define BF22_MIC_DISTANCE_P6			0x12
#define BF22_MIC_DISTANCE_P7			0x13
#define BF22_MIC_DISTANCE_P8			0x14

#define BF22_MIC_DISTANCE_VERY_SHORT	BF22_MIC_DISTANCE_0
#define BF22_MIC_DISTANCE_SHORT			BF22_MIC_DISTANCE_P2
#define BF22_MIC_DISTANCE_MEDIUM		BF22_MIC_DISTANCE_P4
#define BF22_MIC_DISTANCE_LONG			BF22_MIC_DISTANCE_P6

#define BF22_MIC_DISTANCE_MIN			BF22_MIC_DISTANCE_M2
#define BF22_MIC_DISTANCE_MAX			BF22_MIC_DISTANCE_P8

// microphone compression
#define BF22_MIC_COMPRESSION_OFF		0x10
#define BF22_MIC_COMPRESSION_ON			0x11
// limits to check
#define BF22_MIC_COMPRESSION_MIN		BF22_MIC_COMPRESSION_OFF
#define BF22_MIC_COMPRESSION_MAX		BF22_MIC_COMPRESSION_ON

// microphone noise threshold
#define BF22_MIC_THRESHOLD_HIGH			0x10
#define BF22_MIC_THRESHOLD_MID			0x11
#define BF22_MIC_THRESHOLD_LOW			0x12
#define BF22_MIC_THRESHOLD_LOWER		0x13
#define BF22_MIC_THRESHOLD_VERY_LOW		0x14
// limits to check
#define BF22_MIC_THRESHOLD_MIN			BF22_MIC_THRESHOLD_HIGH
#define BF22_MIC_THRESHOLD_MAX			BF22_MIC_THRESHOLD_VERY_LOW

//luminance
#define BF22_LUMINANCE_MIN				0x00
#define BF22_LUMINANCE_MAX				0x14

// line-keys LED states
// bit0 - m - mask
// bit1 - g - green
// bit2 - r - red
// bit3 - R - blink green
// bit4 - G - blink red
//											 //RGrgm
#define BF22_LED_NOCHANGE				0x00 //00000
#define BF22_LED_OFF					0x01 //00001
#define BF22_LED_GREEN					0x03 //00011
#define BF22_LED_RED					0x05 //00101
#define BF22_LED_ORANGE					0x07 //00111
#define BF22_LED_BLINK_OFF_GREEN		0x09 //01001
#define BF22_LED_BLINK_OFF_RED			0x11 //10001
#define BF22_LED_BLINK_OFF_ORANGE		0x19 //11001
#define BF22_LED_BLINK_GREEN_OFF		0x0B //01011
#define BF22_LED_BLINK_GREEN_RED		0x1B //11011
#define BF22_LED_BLINK_GREEN_ORANGE		0x13 //10011
#define BF22_LED_BLINK_RED_OFF			0x15 //10101
#define BF22_LED_BLINK_RED_GREEN		0x1D //11101
#define BF22_LED_BLINK_RED_ORANGE		0x0D //01101
#define BF22_LED_BLINK_ORANGE_OFF		0x1F //11111
#define BF22_LED_BLINK_ORANGE_GREEN		0x17 //10111
#define BF22_LED_BLINK_ORANGE_RED		0x0F //01111

// limits to check
#define BF22_LED_MIN					BF22_LED_NOCHANGE
#define BF22_LED_MAX					BF22_LED_BLINK_ORANGE_OFF


