
/****************************************************************************/
/*		BF07 DEFINES														*/
/****************************************************************************/

// Handsfree speaker levels
#define SBX_SPK_LEVEL_MIN						0x00
#define SBX_SPK_LEVEL_MAX						0x14

// PTT LED State
#define BF07_PTT_LED_OFF						0x00
#define BF07_PTT_LED_ON							0x10
#define BF07_PTT_LED_BLINK						0x20

// Handset speaker levels
#define BF07_HANDSET_SPEAKER_LEVEL_P4			0x00
#define BF07_HANDSET_SPEAKER_LEVEL_P3			0x01
#define BF07_HANDSET_SPEAKER_LEVEL_P2			0x02
#define BF07_HANDSET_SPEAKER_LEVEL_P1			0x03
#define BF07_HANDSET_SPEAKER_LEVEL_0			0x03
#define BF07_HANDSET_SPEAKER_LEVEL_M1			0x04
#define BF07_HANDSET_SPEAKER_LEVEL_M2			0x05
#define BF07_HANDSET_SPEAKER_LEVEL_M3			0x06
#define BF07_HANDSET_SPEAKER_LEVEL_M4			0x07
#define BF07_HANDSET_SPEAKER_LEVEL_M5			0x08
#define BF07_HANDSET_SPEAKER_LEVEL_M6			0x09
#define BF07_HANDSET_SPEAKER_LEVEL_M7			0x0A
#define BF07_HANDSET_HEADSET_ILLEGAL			0xFF

#define BF07_HANDSET_HEADSET_MIN				BF07_HANDSET_SPEAKER_LEVEL_P4
#define BF07_HANDSET_HEADSET_MAX				BF07_HANDSET_SPEAKER_LEVEL_M7

// Alert line modes

// When handset is off-hook:
// Voice(L) is switched to handset
// Alert(R) stays always on speakers
#define BF07_ALERT_AS_ALERT						0x00

// When handset is off-hook:
// Voice(L) and Alert(R) are switched to handset
#define BF07_ALERT_AS_VOICE						0x01

// When handset is off-hook:
// Voice(L) is switched to handset
// Alert(R) is muted
#define BF07_ALERT_NOT_USED						0x02

// mode not defined
#define	BF07_ALERT_ILLEGAL						0xFF

// Devices 
#define BF07_DEVICE_HANDSFREE					0x00
#define BF07_DEVICE_HANDSET						0x01
#define BF07_DEVICE_HANDSFREE_HANDSET			0x04
#define BF07_DEVICE_ILLEGAL						0xFF

// Microphone level (attenuation)
#define BF07_MIC_LEVEL_P3						0x10
#define BF07_MIC_LEVEL_P2						0x11
#define BF07_MIC_LEVEL_P1						0x12
#define BF07_MIC_LEVEL_0						0x13
#define BF07_MIC_LEVEL_M1						0x14
#define BF07_MIC_LEVEL_M2						0x15
#define BF07_MIC_LEVEL_M3						0x16
#define BF07_MIC_LEVEL_M4						0x17
#define BF07_MIC_LEVEL_M5						0x18
#define BF07_MIC_LEVEL_M6						0x19
#define BF07_MIC_LEVEL_M7						0x1A	
#define BF07_MIC_LEVEL_M8						0x1B
#define BF07_MIC_LEVEL_M9						0x1C
#define BF07_MIC_LEVEL_M10						0x1D
#define BF07_MIC_LEVEL_M11						0x1E

#define BF07_MIC_LEVEL_MIN						BF07_MIC_LEVEL_P3
#define BF07_MIC_LEVEL_MAX						BF07_MIC_LEVEL_M11

// Microphone noise threshold
#define BF07_MIC_THRESHOLD_HIGH					0x10
#define BF07_MIC_THRESHOLD_MID					0x11
#define BF07_MIC_THRESHOLD_LOW					0x12
#define BF07_MIC_THRESHOLD_LOWER				0x13
#define BF07_MIC_THRESHOLD_VERY_LOW				0x14

#define BF07_MIC_THRESHOLD_MIN					BF07_MIC_THRESHOLD_HIGH
#define BF07_MIC_THRESHOLD_MAX					BF07_MIC_THRESHOLD_VERY_LOW

// Microphone compression
#define BF07_MIC_COMPRESSION_OFF				0x10
#define BF07_MIC_COMPRESSION_ON					0x11

#define BF07_MIC_COMPRESSION_MIN				BF07_MIC_COMPRESSION_OFF
#define BF07_MIC_COMPRESSION_MAX				BF07_MIC_COMPRESSION_ON

// Microphone optimal distance
#define BF07_MIC_DISTANCE_M2					0x0A
#define BF07_MIC_DISTANCE_M1					0x0B
#define BF07_MIC_DISTANCE_0						0x0C
#define BF07_MIC_DISTANCE_P1					0x0D
#define BF07_MIC_DISTANCE_P2					0x0E
#define BF07_MIC_DISTANCE_P3					0x0F
#define BF07_MIC_DISTANCE_P4					0x10
#define BF07_MIC_DISTANCE_P5					0x11
#define BF07_MIC_DISTANCE_P6					0x12
#define BF07_MIC_DISTANCE_P7					0x13
#define BF07_MIC_DISTANCE_P8					0x14

#define BF07_MIC_DISTANCE_VERY_SHORT			BF07_MIC_DISTANCE_0
#define BF07_MIC_DISTANCE_SHORT					BF07_MIC_DISTANCE_P2
#define BF07_MIC_DISTANCE_MEDIUM				BF07_MIC_DISTANCE_P4
#define BF07_MIC_DISTANCE_LONG					BF07_MIC_DISTANCE_P6

#define BF07_MIC_DISTANCE_MIN					BF07_MIC_DISTANCE_M2
#define BF07_MIC_DISTANCE_MAX					BF07_MIC_DISTANCE_P8

// Echo cancellation state
#define BF07_EC_OFF								0x0F
#define BF07_EC_ON								0x1F
#define BF07_EC_NOT_PRESENT						0xFF

// Showing microphone signal on VU meter
#define BF07_VU_MIC_OFF							0x3C
#define BF07_VU_MIC_ON							0x3D

// Handset sidetone level
#define BF07_SIDETONE_LEVEL_M1					0x00
#define BF07_SIDETONE_LEVEL_M2					0x01
#define BF07_SIDETONE_LEVEL_M3					0x02
#define BF07_SIDETONE_LEVEL_M4					0x03
#define BF07_SIDETONE_LEVEL_M5					0x04
#define BF07_SIDETONE_LEVEL_M6					0x05
#define BF07_SIDETONE_LEVEL_M7					0x06
#define BF07_SIDETONE_LEVEL_M8					0x07
#define BF07_SIDETONE_LEVEL_M9					0x08
#define BF07_SIDETONE_OFF						0xFE
#define BF07_SIDETONE_ILLEGAL					0xFF
// limits to check
#define BF07_SIDETONE_MIN						BF07_SIDETONE_LEVEL_M1
#define BF07_SIDETONE_MAX						BF07_SIDETONE_LEVEL_M9

// Emulate keys
#define BF07_KEY_PTT_HANDSFREE					0x01
#define BF07_KEY_PTT_HANDSET					0x02
#define BF07_KEY_HOOK							0x03

// Key states
#define BF07_HANDSET_ONHOOK						0x80
#define BF07_HANDSET_OFFHOOK					0x00
#define BF07_KEY_PRESSED						0x80
#define BF07_KEY_RELEASED						0x00


// VU meter scenario
#define BF07_VU_SPK_L							0x33
#define BF07_VU_SPK_LR							0x37



