// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the TIPROHIDAPI_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// TIPROHIDAPI_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef TIPROHIDAPI_EXPORTS
#define TIPROHIDAPI_API __declspec(dllexport)
#else
#define TIPROHIDAPI_API __declspec(dllimport)
#endif

/****************************************************************************/
/*		HIDAPI functions (FW Level 1 required)                              */
/****************************************************************************/
TIPROHIDAPI_API int HIDSetLuminance(int nLum);
/* Sets the luminance of the LCD screen										*/
/* arguments (IN)	: Relative luminance (0-20)								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDTouchscreenDisable(void);
/* Disables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDTouchscreenEnable(void);
/* Enables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */


TIPROHIDAPI_API int HIDSetLeds(int nLEDs);
/* Sets the user-defined LED state											*/
/* arguments (IN)	: LEDs to turn ON/OFF (0x00-0x0F)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDDetectDevices(void);
/* Detect Tipro HID API supported devices									*/
/* return value		: command status : 0 == OK, else error code			    */

/****************************************************************************/
/*		HIDAPI functions (FW Level 2 required)                              */
/****************************************************************************/

TIPROHIDAPI_API int HIDEnumerateModules(void);
/* Enumerates devices on TiproBus											*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDReset(void);
/* Sends Reset to the controller											*/
/* return value		: command status : 0 == OK, else error code			    */

/****************************************************************************/
/*		SPEAKERBOX FUNCTIONS                                                */
/****************************************************************************/

TIPROHIDAPI_API int HIDSetSpeakerLevel(int nFsNum, int nLevel);
/* Sets the level of the speakers											*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetSpeakerLevel(int nFsNum, int *nLevel);
/* Returns the level of the speakers										*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetHandsetState(int nHandsetNum, int *nPTTKey, int *nHookState);
/* Returns the state of the keys											*/
/* arguments (IN)	: selected handset module number	                    */
/* arguments (OUT)	: PTT key state	(KEY_PRESSED / KEY_RELEASED)			*/
/*					: Hook state (KEY_PRESSED / KEY_RELEASED)				*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetHandsetStateEx (int nHandsetNum, int *nPTTKey, int *nHookState);
/* Returns the state of the keys											*/
/* arguments (IN)	: selected handset module number	                    */
/* arguments (OUT)	: PTT key state	(KEY_PRESSED / KEY_RELEASED)			*/
/*					: Hook state (KEY_PRESSED / KEY_RELEASED)				*/
/*					: if any of OUT arguments is NULL, handset state is		*/
/*					: sent to system, otherwise just RAW is returned		*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetSbxKeyState (int nFsNum, int nKey, int *nState);
/* Returns the state of the keys											*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: key index												*/
/* arguments (OUT)	: state of the key (KEY_PRESSED / KEY_RELEASED)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDSetSbxLEDState (int nFsNum, int nKey, int nState);
/* Sets the LED state of the illuminated keys								*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: illuminated key index									*/
/*					: state of the LED (LED_ON/LED_OFF)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetSbxLEDState (int nFsNum, int nKey, int *nState);
/* Returns the LED state of the illuminated keys							*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: illuminated key index									*/
/* arguments (OUT)	: state of the LED (LED_ON/LED_OFF)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDSetExternalDeviceLevel (int nFsNum, int nLevel);
/* Sets the level of the connected headset/handset device					*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: level of the signal	 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetExternalDeviceLevel (int nFsNum, int *nLevel);
/* Returns the current level of the connected headset/handset device		*/
/* arguments (IN)	: selected speakerbox module number                     */
/* arguments (OUT)	: level of the signal	 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDGetExternalHeadsetState (int nFsNum, int *nState);
/* Returns the state of the headset											*/
/* arguments (IN)	: selected speakerbox module number	                    */
/* arguments (OUT)	: headset state											*/	
/*								(HEADSET_CONNECTED / HEADSET_DISCONNECTED)	*/
/*																			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDMuteMicrophone (int nFsNum, int nMute);
/* Mutes/un-mutes the microphone signal										*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: mute/un-mute microphone 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDSpeakerboxGoOnline (int nFsNum);
/* Puts speakerbox to On-line mode											*/
/* arguments (IN)	: selected speakerbox module number                     */
/* return value		: command status : 0 == OK, else error code			    */
/*																			*/

TIPROHIDAPI_API int HIDIsSpeakerboxOnline (int nFsNum, int *nOnline);
/* Returns On-line / Off-line mode											*/
/* arguments (IN)	: selected speakerbox module number                     */
/* arguments (OUT)	: 0 - Offline ; 1 - Online			                    */
/* return value		: command status : 0 == OK, else error code			    */
/*																			*/

TIPROHIDAPI_API int HIDSetAlertLine (int nFsNum, int nMode);
/* Sets the function (mode) of the alert line								*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: mode (ALERT, VOICE, NOT USED)							*/
/* return value		: command status : 0 == OK, else error code			    */
/*																			*/
/*																			*/
/*																			*/
/* ON-Line ONLY!															*/

TIPROHIDAPI_API int HIDGetAlertLine (int nFsNum, int *nMode);
/* returns the function (mode) of the alert line							*/
/* arguments (IN)	: selected speakerbox module number                     */
/* arguments (OUT)	: mode (ALERT, VOICE, NOT USED)							*/
/* return value		: command status : 0 == OK, else error code			    */
/*																			*/
/*																			*/
/*																			*/
/* ON-Line ONLY!															*/

TIPROHIDAPI_API int HIDSetActiveDevice (int nFsNum, int nDevice);
/* Sets the device where both speaker and microphone signals				*/
/* will be switched to														*/
/* arguments (IN)	: selected speakerbox module number                     */
/*					: device to be made active								*/
/* return value		: command status : 0 == OK, else error code			    */
/*																			*/
/*																			*/
/*																			*/
/* ON-Line ONLY!															*/

TIPROHIDAPI_API int HIDGetMicrophoneLevel (int nFsNum, int *nLevel);
/* Returns the level of the microphone signal								*/
/* arguments (IN) : selected speakerbox module number						*/
/* arguments (OUT): microphone level										*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDSetMicrophoneLevel (int nFsNum, int nLevel);
/* Sets the level of the microphone signal									*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone level										*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDSetMicrophoneLevelEx (int nFsNum, int nLevel, int nDevice);
/* Sets the level of the microphone signal									*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone level										*/
/*				  : device to set (handsfree, handset/headset)				*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDGetMicrophoneOptimalDistance (int nFsNum, int *nDistance);
/* Returns the optimal distance of the handsfree microphone					*/
/* arguments (IN) : selected speakerbox module number						*/
/* arguments (OUT): microphone optimal distance								*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDSetMicrophoneOptimalDistance (int nFsNum, int nDistance);
/* Sets the optimal distance for the handsfree microphone					*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone optimal distance								*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDSetMicrophoneThreshold (int nFsNum, int nThreshold);
/* Sets the microphone threshold											*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone threshold									*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDGetMicrophoneThreshold (int nFsNum, int *nThreshold);
/* Returns the microphone threshold											*/
/* arguments (IN) : selected speakerbox module number						*/
/* arguments (OUT): microphone threshold									*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDSetMicrophoneCompression (int nFsNum, int nCompression);
/* Sets the microphone compression											*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone compression									*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDGetMicrophoneCompression (int nFsNum, int *nCompression);
/* Returns the microphone compression										*/
/* arguments (IN) : selected speakerbox module number						*/
/* arguments (OUT): microphone compression									*/
/* return value   : command status : 0 == OK, else error code				*/

/** Specific device versions **/
TIPROHIDAPI_API int HIDSetMicrophoneThresholdEx (int nFsNum, int nThreshold, int nDevice);
/* Sets the specific device's microphone threshold							*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone threshold									*/
/*				  : device to set (handsfree, handset/headset)				*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDSetMicrophoneCompressionEx (int nFsNum, int nCompression, int nDevice);
/* Sets the specific device's microphone compression					*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : microphone compression									*/
/*				  : device to set (handsfree, handset/headset)				*/
/* return value   : command status : 0 == OK, else error code				*/

/* Supported if firmware with blink functionality							*/
TIPROHIDAPI_API int HIDSetSbxLEDBlinkSpeed (int nFsNum, int nTBlinkA, int nTBlinkB);
/* Sets the LED blink timings												*/
/* arguments (IN) : selected speakerbox module number						*/
/*				  : ON time in ms (1..5000)									*/
/*				  : OFF time in ms (1..5000)								*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDGetSbxLEDBlinkSpeed (int nFsNum, int *nTBlinkA, int *nTBlinkB);
/* Get LED blink timings													*/
/* arguments (IN) : selected speakerbox module number						*/
/* arguments (OUT): ON time in ms (1..5000)									*/
/*				  : OFF time in ms (1..5000)								*/
/* return value   : command status : 0 == OK, else error code				*/

/****************************************************************************/
/*		CHAMELEON FUNCTIONS													*/
/****************************************************************************/

TIPROHIDAPI_API int HIDChmGoOnline (int nChmNum);
/* Puts Chameleon into On-Line operating mode.                              */
/* arguments (IN)  : selected Chameleon module number						*/
/* arguments (OUT) : none													*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDChmDisplayIcon (int nChmNum, struct CHM_ICON_DATA IconData);
/* Displays the icon from the library on the specified key.                 */
/* arguments (IN)  : selected Chameleon module number                       */
/*				   : address of the key (0x00-0x0F)                         */
/*				   : video type of the icon (NORMAL or INVERSE)             */
/*				   : index of the icon in the icon library                  */
/* arguments (OUT) : none													*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDChmDisplayBitmap (int nChmNum, int nKeyAddr, int nVideoType, struct CHM_BITMAP_DATA BitmapData);
/* Displays the bitmap on the specified key.                 */
/* arguments (IN)  : selected Chameleon module number                       */
/*				   : address of the key (0x00-0x0F)                         */
/*				   : video type of the icon (NORMAL or INVERSE)             */
/*				   : bitmap data							                */
/* arguments (OUT) : none													*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDChmChangeBacklighting (int nChmNum, struct CHM_BACKLIGHTING_DATA BacklightingData);
/* Sets the backlighting parameters for the addressed LCD key.              */
/* arguments (IN)  : selected Chameleon module number                       */
/*				   : address of the key (0x00-0x0F)                         */
/*				   : first color for the key backlight			            */
/*				   : alternate color for the key backlight                  */
/*				   : alternating frequency (switching from color1 to color2)*/
/* arguments (OUT) : none													*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDChmGoToPage (int nChmNum, int nPageNumber);
/* Loads the selected page settings from the configuration memory.			*/
/* arguments (IN)  : selected Chameleon module number                       */
/*				   : page number					                        */
/* arguments (OUT) : none													*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDChmGetPageNumber (int nChmNum, int *nPageNumber);
/* Returns current page number.												*/
/* arguments (IN)  : selected Chameleon module number                       */
/* arguments (OUT) : current page number									*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDChmGetNumberOfPages (int nChmNum, int *nPages);
/* Returns number of preprogrammed pages.									*/
/* arguments (IN)  : selected Chameleon module number                       */
/* arguments (OUT) : number of preprogrammed pages							*/
/* return value    : command status : 0 == OK, else error code			    */

/****************************************************************************/
/*		BF10 FUNCTIONS														*/
/****************************************************************************/
/*																			*/
/* Old functions for BeFree and Speakerbox are updated to support new		*/
/* functionality. Some functions are calling old functions with correct		*/
/* paramters.																*/
/*																			*/
/****************************************************************************/

TIPROHIDAPI_API int HIDBF10SetLuminance (int nIndex);
/* Sets luminance for both stripe and LCD backlight			                */
/* arguments (IN)  : lumninance index (0-darkest; 10-brightest)             */
/* arguments (OUT) : none													*/
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10TouchscreenDisable(void);
/* Disables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10TouchscreenEnable(void);
/* Enables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10SetSpeakerLevel(int nLevel);
/* Sets the level of the speakers											*/
/* arguments (IN)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10GetSpeakerLevel(int *nLevel);
/* Returns the level of the speakers										*/
/* arguments (OUT)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10GetPTTKeyState (int *nState);
/* Returns the state of the PTT key											*/
/* arguments (OUT)	: state of the key (KEY_PRESSED / KEY_RELEASED)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10SetPTTKeyLEDState (int nState);
/* Sets the LED state of illuminated PTT key								*/
/* arguments (IN)	: state of the LED (LED_ON/LED_OFF/LED_BLINK)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10SetPTTKeyLEDStateEx (int nState, int nTBlinkOn, int nTBlinkOff);
/* Sets the operation of the illuminated PTT key with more paramters		*/
/* arguments (IN)	: state of the LED (LED_ON/LED_OFF/LED_BLINK)			*/
/*					: On period for blink mode (ms)							*/
/*					: Off period for blink mode (ms)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10GetPTTKeyLEDState (int *nState);
/* Returns the LED state of the illuminated PTT Key							*/
/* arguments (OUT)	: state of the LED (LED_ON/LED_OFF/LED_BLINK)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10MuteMicrophone (int nMute);
/* Mutes/un-mutes the microphone signal										*/
/* arguments (IN)	: mute/un-mute microphone 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10SetAutoLuminance (int nAutoMode);
/* Sets luminance for both stripe and LCD backlight to be controlled by		*/
/* ambient light sensor.													*/
/* arguments (IN)	: Auto luminance mode									*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF10GetAutoLuminance (int *nAutoMode);
/* Returns the mode of the auto controlled luminance						*/
/* arguments (OUT)	: Auto luminance mode									*/
/* return value		: command status : 0 == OK, else error code			    */

// functions that are also missing in the speakerbox part
TIPROHIDAPI_API int HIDBF10SetMicrophoneLevel (int nLevel);
/* Sets the level of the microphone signal									*/
/* arguments (IN) : microphne level									        */
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10SetMicrophoneOptimalDistance (int nDistance);
/* Sets the optimal distance of the handsfree microphone signal				*/
/* arguments (IN) : microphone optimal distance								*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10SetMicrophoneThreshold (int nThreshold);
/* Sets threshold for the microphone signal									*/
/* arguments (IN) : microphone threshold									*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10SetMicrophoneCompression (int nCompression);
/* Sets compression for the microphone signal								*/
/* arguments (IN) : microphone compression									*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10SetAnalogAudio(int nSettings);
/* Sets the Analog audio options											*/
/* arguments (IN) : select which analog channel is added to the output		*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10GetAnalogAudio(int *nSettings);
/* Returns Analog audio options												*/
/* arguments (OUT): returns which analog channel is added to the output		*/
/* return value   : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10GetMicrophoneLevel (int *nLevel);
/* Returns the level of the microphone signal								*/
/* arguments (OUT) : microphone level										*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10GetMicrophoneOptimalDistance (int *nRange);
/* Returns the optimal distance of the handsfree microphone signal			*/
/* arguments (OUT) : microphone optimal distance							*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10GetMicrophoneThreshold (int *nThreshold);
/* Returns threshold for the microphone signal								*/
/* arguments (OUT) : microphone threshold									*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10GetMicrophoneCompression (int *nCompression);
/* Returns compression for the microphone signal							*/
/* arguments (OUT) : microphone compression									*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF10EnableManualMicrophoneControl(int nEnable);
/* Enables manual control of microphone.									*/
/* If enabled microphone mute and LED are controlled exclusively by API.	*/
/* arguments (IN)	: enable / disable manual control	                    */
/* return value		: command status : 0 == OK, else error code			    */

/****************************************************************************/
/*		BF20 FUNCTIONS														*/
/****************************************************************************/

TIPROHIDAPI_API int HIDBF20SetPCMScenario(int nScenario);
/* Set PCM scenario															*/
/* arguments (IN)	: PCM scenario	(AB2LR / LR2LR)							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetPCMScenario(int *nScenario, int *nInitScenario);
/* Get PCM scenario															*/
/* arguments (OUT)	: PCM scenario	(AB2LR / LR2LR)							*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetMicAmpMode(int nMicAmpMode);
/* Set Microphone amplifier mode (Linear/Logarithmic)						*/
/* arguments (IN)	: Microphone amplifier mode (LIN/LOG)					*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetMicAmpMode(int *nMicAmpMode, int *nInitMicAmpMode);
/* arguments (OUT)	: Microphone amplifier mode (LIN/LOG)					*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetLFSpeakerState(int nState);
/* Set LF speaker state (ON/OFF)											*/
/* arguments (IN)	: LF speaker state (on/off)								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetLFSpeakerState(int *nState, int *nInitState);
/* Get LF speaker state														*/
/* arguments (OUT)	: LF speaker state (on/off)								*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetMicOnVUState(int nState);
/* Sets if microphone level is shown on the VU-meter (ON/OFF)				*/
/* arguments (IN)	: microphone on VU-meter state (on/off)					*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetMicOnVUState(int *nState, int *nInitState);
/* Get microphone level shown on VU-meter state								*/
/* arguments (OUT)	: microphone level on VU-meter state (on/off)			*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetMic2LineInState(int nState);
/* Sets the connection state (ON/OFF) of the gooseneck microphone to the	*/
/* LINE-IN port on the motherboard											*/
/* arguments (IN)	: connection state (ON/OFF)								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetMic2LineInState(int *nState, int *nInitState);
/* Returns the connection state (ON/OFF) of the gooseneck microphone to the	*/
/* LINE-IN port on the motherboard											*/
/* arguments (OUT)	: connection state (ON/OFF)								*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetLineOut2SpkMode(int nMode);
/* Sets the connection mode (OFF/L/R/LR) of the motherboard LINE-OUT port 	*/
/* to the speakers.															*/
/* arguments (IN)	: connection mode (OFF/L/R/LR)							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetLineOut2SpkMode(int *nMode, int *nInitMode);
/* Returns the connection mode (OFF/L/R/LR) of the motherboard LINE-OUT		*/
/* port to the speakers.													*/
/* arguments (OUT)	: connection mode (OFF/L/R/LR)							*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetEchoMode(int nMode);
/* Sets the echo canceler mode (OFF/L/R/LR)									*/
/* arguments (IN)	: echo canceler mode (OFF/L/R/LR)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetEchoMode(int *nMode, int *nInitMode);
/* Returns the echo canceler mode (OFF/L/R/LR)								*/
/* arguments (OUT)	: echo canceler mode (OFF/L/R/LR)						*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20TouchscreenDisable(void);
/* Disables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20TouchscreenEnable(void);
/* Enables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetPTTKeyLEDState(int nState);
/* Sets the LED state of illuminated PTT key								*/
/* arguments (IN)	: PTT LED state (PTT_LED_ON/PTT_LED_OFF/PTT_LED_BLINK)	*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetPTTKeyLEDStateEx(int nState, int nTBlinkOn, int nTBlinkOff);
/* Sets the operation of the illuminated PTT key with more paramters		*/
/* arguments (IN)	: PTT LED state (PTT_LED_ON/PTT_LED_OFF/PTT_LED_BLINK)	*/
/*					: On period for blink mode (ms)							*/
/*					: Off period for blink mode (ms)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetPTTKeyLEDState(int *nState);
/* Returns the LED state of the illuminated PTT Key							*/
/* arguments (OUT)	: state of the LED (LED_ON/LED_OFF/LED_BLINK)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20MuteMicrophone(int nMute);
/* Mutes/un-mutes the microphone signal										*/
/* arguments (IN)	: mute/un-mute microphone 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetLeftSpeakerLevel(int nLevel);
/* Sets the level of the left speaker										*/
/* arguments (IN)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetLeftSpeakerLevel(int *nLevel);
/* Returns the level of the left speaker									*/
/* arguments (OUT)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetRightSpeakerLevel(int nLevel);
/* Sets the level of the right speaker										*/
/* arguments (IN)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetRightSpeakerLevel(int *nLevel);
/* Returns the level of the right speaker									*/
/* arguments (OUT)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetMicrophoneLevel(int nLevel, bool bSetInit);
/* Sets the gooseneck microphone level										*/
/* arguments (IN)	: microphone level										*/
/*					: write initial state to EEPROM							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetMicrophoneLevel(int *nLevel, int *nInitLevel);
/* Returns the googeneck microphone level									*/
/* arguments (OUT)	: microphone level										*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20SetMicrophoneOptimalDistance(int nDistance, bool bSetInit);
/* Sets the microphone optimal distance										*/
/* arguments (IN)	: microphone optimal distance							*/
/*					: write initial state to EEPROM							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetMicrophoneOptimalDistance(int *nDistance, int *nInitDistance);
/* Gets the microphone optimal distance										*/
/* arguments (OUT)	: microphone optimal distance							*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetMicrophoneThreshold(int *nThreshold, int *nInitThreshold);
/* Returns threshold for the microphone signal								*/
/* arguments (OUT)  : microphone threshold									*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF20SetMicrophoneThreshold(int nThreshold, bool bSetInit);
/* Sets threshold for the microphone signal									*/
/* arguments (IN)   : microphone threshold									*/
/*				    : write initial state to EEPROM							*/
/* return value     : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF20GetMicrophoneCompression(int *nCompression, int *nInitCompression);
/* Returns compression for the microphone signal								*/
/* arguments (OUT)	: microphone compression									*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF20SetMicrophoneCompression(int nCompression, bool bSetInit);
/* Sets compression for the microphone signal									*/
/* arguments (IN)	: microphone compression									*/
/*					: write initial state to EEPROM							*/
/* return value		: command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF20SetLuminance(int nLuminance);
/* Sets luminance for both stripe and LCD backlight			                */
/* arguments (IN)  : luminance index (0-darkest; 20-brightest)             */
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF20GetPTTKeyState(int *nState);
/* Returns the state of the PTT key											*/
/* arguments (OUT)	: state of the key (KEY_PRESSED / KEY_RELEASED)			*/
/* return value		: command status : 0 == OK, else error code			    */

/****************************************************************************/
/*		BF22 FUNCTIONS														*/
/****************************************************************************/

TIPROHIDAPI_API int HIDBF22SetPCMScenario(int nScenario);
/* Set PCM scenario															*/
/* arguments (IN)	: PCM scenario	(AB2LR / LR2LR)							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetPCMScenario(int *nScenario, int *nInitScenario);
/* Get PCM scenario															*/
/* arguments (OUT)	: PCM scenario	(AB2LR / LR2LR)							*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetMicAmpMode(int nMicAmpMode);
/* Set Microphone amplifier mode (Linear/Logarithmic)						*/
/* arguments (IN)	: Microphone amplifier mode (LIN/LOG)					*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetMicAmpMode(int *nMicAmpMode, int *nInitMicAmpMode);
/* arguments (OUT)	: Microphone amplifier mode (LIN/LOG)					*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetLFSpeakerState(int nState);
/* Set LF speaker state (ON/OFF)											*/
/* arguments (IN)	: LF speaker state (on/off)								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetLFSpeakerState(int *nState, int *nInitState);
/* Get LF speaker state														*/
/* arguments (OUT)	: LF speaker state (on/off)								*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetMicOnVUState(int nState);
/* Sets if microphone level is shown on the VU-meter (ON/OFF)				*/
/* arguments (IN)	: microphone on VU-meter state (on/off)					*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetMicOnVUState(int *nState, int *nInitState);
/* Get microphone level shown on VU-meter state								*/
/* arguments (OUT)	: microphone level on VU-meter state (on/off)			*/
/*					: Initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetMic2LineInState(int nState);
/* Sets the connection state (ON/OFF) of the gooseneck microphone to the	*/
/* LINE-IN port on the motherboard											*/
/* arguments (IN)	: connection state (ON/OFF)								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetMic2LineInState(int *nState, int *nInitState);
/* Returns the connection state (ON/OFF) of the gooseneck microphone to the	*/
/* LINE-IN port on the motherboard											*/
/* arguments (OUT)	: connection state (ON/OFF)								*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetLineOut2SpkMode(int nMode);
/* Sets the connection mode (OFF/L/R/LR) of the motherboard LINE-OUT port 	*/
/* to the speakers.															*/
/* arguments (IN)	: connection mode (OFF/L/R/LR)							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetLineOut2SpkMode(int *nMode, int *nInitMode);
/* Returns the connection mode (OFF/L/R/LR) of the motherboard LINE-OUT		*/
/* port to the speakers.													*/
/* arguments (OUT)	: connection mode (OFF/L/R/LR)							*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetEchoMode(int nMode);
/* Sets the echo canceler mode (OFF/L/R/LR)									*/
/* arguments (IN)	: echo canceler mode (OFF/L/R/LR)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetEchoMode(int *nMode, int *nInitMode);
/* Returns the echo canceler mode (OFF/L/R/LR)								*/
/* arguments (OUT)	: echo canceler mode (OFF/L/R/LR)						*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22TouchscreenDisable(void);
/* Disables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22TouchscreenEnable(void);
/* Enables touchscreen														*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetPTTKeyLEDState(int nState);
/* Sets the LED state of illuminated PTT key								*/
/* arguments (IN)	: PTT LED state (PTT_LED_ON/PTT_LED_OFF/PTT_LED_BLINK)	*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetPTTKeyLEDStateEx(int nState, int nTBlinkOn, int nTBlinkOff);
/* Sets the operation of the illuminated PTT key with more paramters		*/
/* arguments (IN)	: PTT LED state (PTT_LED_ON/PTT_LED_OFF/PTT_LED_BLINK)	*/
/*					: On period for blink mode (ms)							*/
/*					: Off period for blink mode (ms)						*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetPTTKeyLEDState(int *nState);
/* Returns the LED state of the illuminated PTT Key							*/
/* arguments (OUT)	: state of the LED (LED_ON/LED_OFF/LED_BLINK)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22MuteMicrophone(int nMute);
/* Mutes/un-mutes the microphone signal										*/
/* arguments (IN)	: mute/un-mute microphone 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetLeftSpeakerLevel(int nLevel);
/* Sets the level of the left speaker										*/
/* arguments (IN)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetLeftSpeakerLevel(int *nLevel);
/* Returns the level of the left speaker									*/
/* arguments (OUT)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetRightSpeakerLevel(int nLevel);
/* Sets the level of the right speaker										*/
/* arguments (IN)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetRightSpeakerLevel(int *nLevel);
/* Returns the level of the right speaker									*/
/* arguments (OUT)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetMicrophoneLevel(int nLevel, bool bSetInit);
/* Sets the gooseneck microphone level										*/
/* arguments (IN)	: microphone level										*/
/*					: write initial state to EEPROM							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetMicrophoneLevel(int *nLevel, int *nInitLevel);
/* Returns the googeneck microphone level									*/
/* arguments (OUT)	: microphone level										*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetMicrophoneOptimalDistance(int nDistance, bool bSetInit);
/* Sets the microphone optimal distance										*/
/* arguments (IN)	: microphone optimal distance							*/
/*					: write initial state to EEPROM							*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetMicrophoneOptimalDistance(int *nDistance, int *nInitDistance);
/* Gets the microphone optimal distance										*/
/* arguments (OUT)	: microphone optimal distance							*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetMicrophoneThreshold(int *nThreshold, int *nInitThreshold);
/* Returns threshold for the microphone signal								*/
/* arguments (OUT)  : microphone threshold									*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF22SetMicrophoneThreshold(int nThreshold, bool bSetInit);
/* Sets threshold for the microphone signal									*/
/* arguments (IN)   : microphone threshold									*/
/*				    : write initial state to EEPROM							*/
/* return value     : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF22GetMicrophoneCompression(int *nCompression, int *nInitCompression);
/* Returns compression for the microphone signal								*/
/* arguments (OUT)	: microphone compression									*/
/*					: initial state from EEPROM								*/
/* return value		: command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF22SetMicrophoneCompression(int nCompression, bool bSetInit);
/* Sets compression for the microphone signal									*/
/* arguments (IN)	: microphone compression									*/
/*					: write initial state to EEPROM							*/
/* return value		: command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDBF22SetLuminance(int nLuminance);
/* Sets luminance for both stripe and LCD backlight			                */
/* arguments (IN)  : luminance index (0-darkest; 20-brightest)             */
/* return value    : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22GetPTTKeyState(int *nState);
/* Returns the state of the PTT key											*/
/* arguments (OUT)	: state of the key (KEY_PRESSED / KEY_RELEASED)			*/
/* return value		: command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDBF22SetLineKeysLedState(int nKey1State, int nKey2State, 
	int nKey3State,	int nKey4State, int nKey5State, int nKey6State, int nKey7State, 
	int nKey8State, int nKey9State, int nKey10State, int nKey11State, int nKey12State, 
	int nKey13State, int nKey14State, int nKey15State, int nKey16State);
/* Sets the LED state for each key LED of Line-keys									*/
/* arguments (IN)	: LED state (for each key - 16 keys)							*/
/*	(BF22_LED_NOCHANGE/BF22_LED_OFF/BF22_LED_GREEN/BF22_LED_RED/BF22_LED_ORANGE/	*/
/*	BF22_LED_BLINK_OFF_GREEN/BF22_LED_BLINK_OFF_RED/BF22_LED_BLINK_OFF_ORANGE/		*/
/*	BF22_LED_BLINK_GREEN_OFF/BF22_LED_BLINK_GREEN_RED/BF22_LED_BLINK_GREEN_ORANGE/	*/
/*	BF22_LED_BLINK_RED_OFF/BF22_LED_BLINK_RED_GREEN/BF22_LED_BLINK_RED_ORANGE/		*/
/*	BF22_LED_BLINK_ORANGE_OFF/BF22_LED_BLINK_ORANGE_GREEN/BF22_LED_BLINK_ORANGE_RED)*/
/* return value		: command status : 0 == OK, else error code						*/

TIPROHIDAPI_API int HIDBF22GetLineKeysLedState(int *nKey1State, int *nKey2State, 
	int *nKey3State, int *nKey4State, int *nKey5State, int *nKey6State, int *nKey7State, 
	int *nKey8State, int *nKey9State, int *nKey10State, int *nKey11State, int *nKey12State, 
	int *nKey13State, int *nKey14State, int *nKey15State, int *nKey16State);
/* Returns the LED state for each key LED of Line-keys								*/
/* arguments (OUT)	: LED state (for each key - 16 keys)							*/
/*	(BF22_LED_OFF/BF22_LED_GREEN/BF22_LED_RED/BF22_LED_ORANGE/						*/
/*	BF22_LED_BLINK_OFF_GREEN/BF22_LED_BLINK_OFF_RED/BF22_LED_BLINK_OFF_ORANGE/		*/
/*	BF22_LED_BLINK_GREEN_OFF/BF22_LED_BLINK_GREEN_RED/BF22_LED_BLINK_GREEN_ORANGE/	*/
/*	BF22_LED_BLINK_RED_OFF/BF22_LED_BLINK_RED_GREEN/BF22_LED_BLINK_RED_ORANGE/		*/
/*	BF22_LED_BLINK_ORANGE_OFF/BF22_LED_BLINK_ORANGE_GREEN/BF22_LED_BLINK_ORANGE_RED)*/
/* return value		: command status : 0 == OK, else error code						*/


/****************************************************************************/
/*		Handset functions													*/
/****************************************************************************/

TIPROHIDAPI_API int HIDHandsetSetMicrophoneCompression (int nHandsetNum, int nCompression);
/* Set compression for the microphone signal								*/
/* arguments (IN) : selected handset module number							*/
/*				  : microphone compression									*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDHandsetSetMicrophoneThreshold (int nHandsetNum, int nThreshold);
/* Set compression for the microphone signal								*/
/* arguments (IN) : selected handset module number							*/
/*				  : microphone threshold									*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDHandsetSetMicrophoneLevel (int nHandsetNum, int nLevel);
/* Set compression for the microphone signal								*/
/* arguments (IN) : selected handset module number							*/
/*				  : microphone level										*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDHandsetGetMicrophoneCompression (int nHandsetNum, int *nCompression);
/* Returns compression for the microphone signal							*/
/* arguments (IN) : selected handset module number							*/
/* arguments (OUT) : microphone compression									*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDHandsetGetMicrophoneThreshold (int nHandsetNum, int *nThreshold);
/* Returns compression for the microphone signal							*/
/* arguments (IN) : selected handset module number							*/
/* arguments (OUT) : microphone threshold									*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDHandsetGetMicrophoneLevel (int nHandsetNum, int *nLevel);
/* Returns compression for the microphone signal							*/
/* arguments (IN) : selected handset module number							*/
/* arguments (OUT) : microphone level										*/
/* return value  : command status : 0 == OK, else error code				*/

TIPROHIDAPI_API int HIDHandsetSetSpeakerLevel(int nHandsetNum, int nLevel);
/* Sets the level of the handset speaker									*/
/* arguments (IN) : selected handset module number							*/
/*				  : speaker level			 								*/
/* return value	  : command status : 0 == OK, else error code			    */

TIPROHIDAPI_API int HIDHandsetGetSpeakerLevel(int nHandsetNum, int *nLevel);
/* Returns the level of the handset speaker									*/
/* arguments (OUT)	: speaker level			 								*/
/* return value		: command status : 0 == OK, else error code			    */

/****************************************************************************/
/*		HIDAPI telephony functions (HID telephony hardware required)        */
/****************************************************************************/

TIPROHIDAPI_API int HIDDetectTelephonyDevices();
TIPROHIDAPI_API int HIDGetNumOfDetectedTelephonyDevices();
TIPROHIDAPI_API int HIDGetTelephonyDeviceProductString(USHORT hidIx, PVOID pString, ULONG lBufferLen);
TIPROHIDAPI_API int HIDGetTelephonyDevice_VID_PID(USHORT hidIx, USHORT *nVID, USHORT *nPID);
TIPROHIDAPI_API int HIDGetTelephonyDeviceManufacturerString(USHORT hidIx, PVOID pString, ULONG lBufferLen);

// currently not supported in hardware, not to be used
TIPROHIDAPI_API int HIDGetTelephonyDeviceSNString(USHORT hidIx, PVOID pString, ULONG lBufferLen);


#if 1	// new combined function for registring callbacks
// callback functions for returning pressed/released keys and status of the thread: 
//
// fnCallback(USHORT nID, USHORT nUsagePage, USHORT nLinkUsage, USHORT nUsage, bool bPressed);
//
// Parameters:
//		nID;					// ID of the telephony device (supporting more then one telephony devices on the same PC)
//		nUsagePage;				// top collection usage page (for now always 0x0b = Telephony)
//		nLinkUsage;				// usage of the specific link collection (0x01 = Phone, 0x06 = Key Pad, 0x07 = Progrmable Button)
//		nUsage;					// usage at the specific collection
//		bPressed;				// key pressed = TRUE or released = FALSE
//
// fnKeyStatusCallback(USHORT nID, int nStatus, int nErrCode, int nRFUParam);
//
// Parameters:
//		nID;					// ID of the telephony device (supporting more then one telephony devices on the same PC)
//		nStatus;				// Status of the thread ( to be defined later... for instance 0x00 = Stopped, 0x01 = Running ... )
//		nErrCode;				// ErrCode for reported status ( to be defined later )
//		nRFUParam;				// Reserved for future use ( to be defined later )
//
// fnKeyStatusCallback can be NULL if not needed
//
// If Visual Studio 2010 or later is used callback can be defined inside of the class using std:bind
#if _MSC_VER > 1500
	#define _VARIADIC_MAX 10
	#include <functional>
	typedef std::function<int(USHORT,USHORT,USHORT,USHORT,bool)> tfnCallbackEx;
	typedef std::function<int(USHORT,int,int,int)> tfnThreadStatusEx;
	TIPROHIDAPI_API int HIDRegisterTelephonyCallbacksEx(USHORT hidIx, tfnCallbackEx fnKeyCallback, tfnThreadStatusEx fnKeyStatusCallback);
#endif
//
// example how to register callback function that is part of a class:
//
//	using namespace std::placeholders;
//  HIDRegisterTelephonyKeysCallbackEx(0,std::bind(&CExampleDlg::OnTelKeyPress,this,_1,_2,_3,_4,_5),NULL);
//
// else normal callback function defintion
typedef int (__stdcall *tfnCallback)(USHORT, USHORT, USHORT, USHORT, bool);
typedef int (__stdcall *tfnThreadStatus)(USHORT, int, int, int);
TIPROHIDAPI_API int HIDRegisterTelephonyCallbacks(USHORT hidIx, tfnCallback fnKeyCallback, tfnThreadStatus fnKeyStatusCallback);

#else
// callback function for returning pressed/released keys: fnCallback(USHORT nID, USHORT nUsagePage, USHORT nLinkUsage, USHORT nUsage, bool bPressed);
//
// Parameters:
//		nID;					// ID of the telephony device (supporting more then one telephony devices on the same PC)
//		nUsagePage;				// top collection usage page (for now always 0x0b = Telephony)
//		nLinkUsage;				// usage of the specific link collection (0x01 = Phone, 0x06 = Key Pad, 0x07 = Progrmable Button)
//		nUsage;					// usage at the specific collection
//		bPressed;				// key pressed = TRUE or released = FALSE
//
// If Visual Studio 2010 or later is used callback can be defined inside of the class using std:bind
#if _MSC_VER > 1500
	#define _VARIADIC_MAX 10
	#include <functional>
	typedef std::function<int(USHORT,USHORT,USHORT,USHORT,bool)> tfnCallbackEx;
	TIPROHIDAPI_API int HIDRegisterTelephonyKeysCallbackEx(USHORT hidIx, tfnCallbackEx fnKeyCallback);
#endif
//
// example how to register callback function that is part of a class:
//
//	using namespace std::placeholders;
//  HIDRegisterTelephonyKeysCallbackEx(0,std::bind(&CExampleDlg::OnTelKeyPress,this,_1,_2,_3,_4,_5));
//
// else normal callback function defintion
typedef int (__stdcall *tfnCallback)(USHORT, USHORT, USHORT, USHORT, bool);
TIPROHIDAPI_API int HIDRegisterTelephonyKeysCallback(USHORT hidIx, tfnCallback fnKeyCallback);


// prepared for future development 
// callback function for returning status of the thread: fnThreadStatus(USHORT nID, int nStatus, int nErrCode, int nRFUParam);
//
// Parameters:
//		nID;					// ID of the telephony device (supporting more then one telephony devices on the same PC)
//		nStatus;				// Status of the thread ( to be defined later... for instance 0x00 = Stopped, 0x01 = Running ... )
//		nErrCode;				// ErrCode for reported status ( to be defined later )
//		nRFUParam;				// Reserved for future use ( to be defined later )
// If Visual Studio 2010 or later is used callback can be defined inside of the class using std:bind
#if _MSC_VER > 1500
	typedef std::function<int(USHORT,int,int,int)> tfnThreadStatusEx;
	TIPROHIDAPI_API int HIDRegisterTelephonyKeysStatusCallbackEx(USHORT hidIx, tfnThreadStatusEx fnKeyStatusCallback);
#endif
typedef int (__stdcall *tfnThreadStatus)(USHORT, int, int, int);
TIPROHIDAPI_API int HIDRegisterTelephonyKeysStatusCallback(USHORT hidIx, tfnThreadStatus fnKeyStatusCallback);
#endif

TIPROHIDAPI_API int HIDStopTelephonyKeyDevice(USHORT hidIx);
TIPROHIDAPI_API int HIDGetTelephonyDevicePath(USHORT hidIx, PVOID pString, ULONG lBufferLen);

/****************************************************************************/
/*		Tiprobus / module functions and definitions                         */
/****************************************************************************/
//
// Module type definitions:
#define MODULE_TYPE_UNKNOWN				0x00;
#define MODULE_TYPE_MATRIX				0x01;
#define MODULE_TYPE_SPEAKERBOX			0x02;
#define MODULE_TYPE_SPEAKERBOX_VOLUME	0x03;
#define MODULE_TYPE_CHAMELEON			0x04;
#define MODULE_TYPE_HANDSET				0x05;
#define MODULE_TYPE_BF15				0x06;
#define MODULE_TYPE_BF10				0x07;
#define MODULE_TYPE_BF10_AUDIO			0x08;
#define MODULE_TYPE_BF20				0x09;
#define MODULE_TYPE_BF20_AUDIO			0x0A;
#define MODULE_TYPE_BF22				0x0B;
#define MODULE_TYPE_BF22_LINEKEYS		0x0C;
#define MODULE_TYPE_UNSUPPORTED			0xFF;

TIPROHIDAPI_API int HIDGetModuleVersion(int nIndex, unsigned char *nVerMaj, unsigned char *nVerMin, unsigned char *nVerBuild);
TIPROHIDAPI_API int HIDGetModuleVersionEx(int nIndex, unsigned char *nVerMaj, unsigned char *nVerMin, unsigned char *nVerBuild, unsigned char *nModuleType, unsigned char *nModuleID);

TIPROHIDAPI_API int HIDGetControllerInfo(int *nVerMaj, int *nVerMin, int *nVerBuild,int *nVerCustom, int *nFWLevel);
TIPROHIDAPI_API int HIDGetManufacturerString(void *pString, unsigned long ulBufferLen);
TIPROHIDAPI_API int HIDGetProductString(void *pString, unsigned long ulBufferLen);
