Name: e100
Summary: Intel(R) PRO/100 driver for Linux
Version: 2.3.43
Release: 1
Source: %{name}-%{version}.tar.gz
Vendor: Intel Corporation
License: GPL
ExclusiveOS: linux
Group: System Environment/Kernel
%define find() %(for f in %*; do if [ -e $f ]; then echo $f; break; fi; done)
%define _pcitable /usr/share/kudzu/pcitable /usr/share/hwdata/pcitable /dev/null
%define pcitable  %find %{_pcitable}
Requires: kernel
Provides: %{name}
URL: http://support.intel.com/support/go/linux/e100.htm
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
This package contains the Linux driver for the
Intel(R) PRO/100 Family of Server Adapters.

%prep
%setup

%build
mkdir -p %{buildroot}

SwitchRHKernel () {
	CFLAGS_EXTRA=""
	for K in $2 ; do
		if [ $K == $1 ] ; then
			CFLAGS_EXTRA="$CFLAGS_EXTRA -D__BOOT_KERNEL_$K=1"
		else
			CFLAGS_EXTRA="$CFLAGS_EXTRA -D__BOOT_KERNEL_$K=0"
		fi
	done
}

KV=$(uname -r)

KSP="/lib/modules/$KV/build
     /usr/src/linux-$KV
     /usr/src/linux-$(echo $KV | sed 's/-.*//')
     /usr/src/kernel-headers-$KV
     /usr/src/kernel-source-$KV
     /usr/src/linux-$(echo $KV | sed 's/\([0-9]*\.[0-9]*\)\..*/\1/')
     /usr/src/linux"

KSRC=$(for d in $KSP ; do [ -e $d/include/linux ] && echo $d; echo;  done)
KSRC=$(echo $KSRC | awk '{ print $1 }')

if [ -e $KSRC/include/linux/rhconfig.h ] ; then
	RHKL=$(grep 'BOOT_KERNEL_.* [01]' /boot/kernel.h |
	       sed 's/.*BOOT_KERNEL_\(.*\) [01]/\1/')
	if echo $RHKL | grep BIGMEM
	then
		RHKL=$(echo $RHKL | sed 's/ENTERPRISE//')
	fi
	if echo $RHKL | grep HUGEMEM
	then
		RHKL=$(echo $RHKL | sed 's/BIGMEM//')
	fi
	for K in $RHKL ; do
		SwitchRHKernel $K "$RHKL"
		make -C src clean
		make -C src INSTALL_MOD_PATH=%{buildroot} \
			MANDIR=%{_mandir} CFLAGS_EXTRA="$CFLAGS_EXTRA" install
	done
else
	make -C src clean
	make -C src INSTALL_MOD_PATH=%{buildroot} MANDIR=%{_mandir} install
fi

%install
# Append .new to driver name to avoid conflict with kernel RPM
cd %{buildroot}
find lib -name e100.o -exec mv {} {}.new \; \
         -fprintf %{_builddir}/%{name}-%{version}/file.list "/%p.new\n"

%clean
rm -rf %{buildroot}

%files -f %{_builddir}/%{name}-%{version}/file.list
%defattr(-,root,root)
%{_mandir}/man7/e100.7.gz
%doc LICENSE
%doc README
%doc ldistrib.txt
%doc file.list

%post
FL="%{_docdir}/%{name}-%{version}/file.list
    %{_docdir}/%{name}/file.list"
FL=$(for d in $FL ; do if [ -e $d ]; then echo $d; break; fi;  done)

if [ -d /usr/local/lib/%{name} ]; then
	rm -rf /usr/local/lib/%{name}
fi

# Save old drivers (aka .o and .o.gz)
for k in $(sed 's/\/lib\/modules\/\([0-9a-zA-Z\.\-]*\).*/\1/' $FL) ; 
do
	d_drivers=/lib/modules/$k
	d_usr=/usr/local/lib/%{name}/$k
	mkdir -p $d_usr
	cd $d_drivers; find . -name %{name}.o -exec cp --parents {} $d_usr \; -exec rm -f {} \;
	cd $d_drivers; find . -name %{name}.o.gz -exec cp --parents {} $d_usr \; -exec rm -f {} \;
done

# Add driver link
for f in $(sed 's/\.new$//' $FL) ; do
	ln -f $f.new $f 
done

BK_LIST=$(sed 's/\/lib\/modules\/\([0-9a-zA-Z\.\-]*\).*/\1/' $FL)
MATCH=no
for i in $BK_LIST
do
	if [ $(uname -r) == $i ] ; then
		MATCH=YES
		break
	fi
done
if [ $MATCH == no ] ; then
	echo -n "WARNING: Running kernel is $(uname -r).  "
	echo -n "RPM supports kernels (  "
	for i in $BK_LIST
	do
		echo -n "$i  "
	done
	echo ")"
fi

# If any adapters are configured to use eepro100, reconfigure to use e100.
if ( grep eepro100 /etc/modules.conf > /dev/null 2>&1 ); then
        mv -f /etc/modules.conf /etc/modules.conf.OLD
        sed -e s/eepro100/e100/g /etc/modules.conf.OLD >> /etc/modules.conf
else
        rm -f /etc/modules.conf.OLD
fi

if [ -f /etc/redhat-release ]
then
# Update Kudzu's device table such that future devices will use e100,
# not eepro100.
if ( grep eepro100 %{pcitable} > /dev/null 2>&1 ); then
        mv -f %{pcitable} %{pcitable}.OLD
        sed -e s/eepro100/e100/g %{pcitable}.OLD >> %{pcitable}
fi
fi

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

%preun
# If doing RPM un-install
if [ $1 -eq 0 ] ; then
	FL="%{_docdir}/%{name}-%{version}/file.list
    		%{_docdir}/%{name}/file.list"
	FL=$(for d in $FL ; do if [ -e $d ]; then echo $d; break; fi;  done)

	# Remove driver link
	for f in $(sed 's/\.new$//' $FL) ; do
		rm -f $f
	done

	# Restore old drivers
	if [ -d /usr/local/lib/%{name} ]; then
		cd /usr/local/lib/%{name}; find . -name '%{name}.o*' -exec cp --parents {} /lib/modules/ \;
		rm -rf /usr/local/lib/%{name}
	fi
fi

%postun
# If any adapters were configured to use eepro100, restore the original.
if [ -e /etc/modules.conf.OLD ]; then
       if ( grep eepro100 /etc/modules.conf.OLD > /dev/null 2>&1 ); then
               rm -f /etc/modules.conf.OLD
               mv -f /etc/modules.conf /etc/modules.conf.OLD
               sed -e s/e100$/eepro100/g /etc/modules.conf.OLD >> /etc/modules.conf
       fi
fi

if [ -f /etc/redhat-release ]
then
# Update Kudzu's device table such that future devices that will use
# eepro100 if this was the set before e100 install.
if [ -e %{pcitable}.OLD ]; then
       if ( grep eepro100 %{pcitable}.OLD > /dev/null 2>&1 ); then
               mv -f %{pcitable} %{pcitable}.OLD
               sed -e s/\"e100\"/\"eepro100\"/g %{pcitable}.OLD >> %{pcitable}
               rm -f %{pcitable}.OLD
       fi
fi
fi

uname -r | grep BOOT || /sbin/depmod -a > /dev/null 2>&1 || true

