
/****************************************************************************/
/*		BF20 DEFINES														*/
/****************************************************************************/

// PCM scenario
#define BF20_PCM_SCENARIO_AB			0x3C
#define BF20_PCM_SCENARIO_LR			0x3D
#define BF20_PCM_SCENARIO_VOID			0x3F
#define BF20_PCM_SCENARIO_MASK			0x03

// microphone amplifier mode
#define BF20_MICAMP_MODE_LOG			0x33
#define BF20_MICAMP_MODE_LIN			0x37
#define BF20_MICAMP_MODE_VOID			0x3F
#define BF20_MICAMP_MODE_MASK			0x0C

// central (low frequency) speaker 
#define BF20_LF_SPK_OFF					0x3C
#define BF20_LF_SPK_ON					0x3D
#define BF20_LF_SPK_VOID				0x3F
#define BF20_LF_SPK_MASK				0x03

// showing microphone signal on VU meter
#define BF20_VU_AB_MIC_OFF				0x33
#define BF20_VU_AB_MIC_ON				0x37
#define BF20_VU_AB_MIC_VOID				0x3F
#define BF20_VU_AB_MIC_MASK				0x0C

// analog line out to speakers
#define BF20_LINE_OUT_OFF_SPK			0x10
#define BF20_LINE_OUT_ON_L_SPK			0x11
#define BF20_LINE_OUT_ON_R_SPK			0x12
#define BF20_LINE_OUT_ON_LR_SPK			0x13
#define BF20_LINE_OUT_VOID				0x14
#define BF20_LINE_OUT_MASK				0x03

// microphone to analog line in
#define BF20_MIC_OFF_LINE_IN			0x04
#define BF20_MIC_ON_LINE_IN				0x0C
#define BF20_MIC_LINE_IN_VOID			0x14
#define BF20_MIC_LINE_IN_MASK			0x08

// echo canceller
#define BF20_EC_OFF						0x00
#define BF20_EC_ON_L					0x01
#define BF20_EC_ON_R					0x02
#define BF20_EC_ON_LR					0x03
#define BF20_EC_VOID					0x07
#define BF20_EC_MASK					0x03

//microphone level (attenuation)
#define BF20_MIC_LEVEL_P3				0x10
#define BF20_MIC_LEVEL_P2				0x11
#define BF20_MIC_LEVEL_P1				0x12
#define BF20_MIC_LEVEL_0				0x13
#define BF20_MIC_LEVEL_M1				0x14
#define BF20_MIC_LEVEL_M2				0x15
#define BF20_MIC_LEVEL_M3				0x16
#define BF20_MIC_LEVEL_M4				0x17
#define BF20_MIC_LEVEL_M5				0x18
#define BF20_MIC_LEVEL_M6				0x19
#define BF20_MIC_LEVEL_M7				0x1A	
#define BF20_MIC_LEVEL_M8				0x1B
#define BF20_MIC_LEVEL_M9				0x1C
#define BF20_MIC_LEVEL_M10				0x1D
#define BF20_MIC_LEVEL_M11				0x1E

#define BF20_MIC_LEVEL_MIN				BF20_MIC_LEVEL_P3
#define BF20_MIC_LEVEL_MAX				BF20_MIC_LEVEL_M11

//microphone optimal distance
#define BF20_MIC_DISTANCE_M2			0x0A
#define BF20_MIC_DISTANCE_M1			0x0B
#define BF20_MIC_DISTANCE_0				0x0C
#define BF20_MIC_DISTANCE_P1			0x0D
#define BF20_MIC_DISTANCE_P2			0x0E
#define BF20_MIC_DISTANCE_P3			0x0F
#define BF20_MIC_DISTANCE_P4			0x10
#define BF20_MIC_DISTANCE_P5			0x11
#define BF20_MIC_DISTANCE_P6			0x12
#define BF20_MIC_DISTANCE_P7			0x13
#define BF20_MIC_DISTANCE_P8			0x14

#define BF20_MIC_DISTANCE_VERY_SHORT	BF20_MIC_DISTANCE_0
#define BF20_MIC_DISTANCE_SHORT			BF20_MIC_DISTANCE_P2
#define BF20_MIC_DISTANCE_MEDIUM		BF20_MIC_DISTANCE_P4
#define BF20_MIC_DISTANCE_LONG			BF20_MIC_DISTANCE_P6

#define BF20_MIC_DISTANCE_MIN			BF20_MIC_DISTANCE_M2
#define BF20_MIC_DISTANCE_MAX			BF20_MIC_DISTANCE_P8


